/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.eventlog;

import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.pa.eventlog.EventLogBaseNode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogConfigPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class EventLogTreeCellRenderer
extends JPanel
implements TreeCellRenderer,
MouseListener {
    EventLogConfigPanel m_panel = null;
    private JCheckBox m_checkBox = new JCheckBox();
    private JLabel m_label = new JLabel();
    private int checkBoxHotspot;
    private JTree m_tree;

    public EventLogTreeCellRenderer(EventLogConfigPanel p, JTree tree) {
        this.checkBoxHotspot = new JCheckBox().getPreferredSize().width;
        this.m_tree = null;
        this.m_panel = p;
        this.m_tree = tree;
        p.getTree().addMouseListener(this);
        this.setLayout(new BorderLayout());
        this.setOpaque(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        EventLogBaseNode node = (EventLogBaseNode)value;
        this.m_checkBox.setSelected(node.isSelected());
        this.m_checkBox.setEnabled(node.isEnabled() && tree.isEnabled());
        if (node.getIcon() != null) {
            this.m_label.setIcon(node.getIcon());
        }
        this.m_label.setText(node.getName());
        this.m_label.setEnabled(node.isEnabled());
        if (isSelected) {
            this.setBackground(SystemColor.textHighlight);
            this.m_label.setBackground(SystemColor.textHighlight);
            this.m_label.setForeground(SystemColor.textHighlightText);
        } else {
            this.setBackground(tree.getBackground());
            this.m_checkBox.setBackground(tree.getBackground());
            this.m_label.setBackground(tree.getBackground());
            this.m_label.setForeground(tree.getForeground());
        }
        this.removeAll();
        this.add((Component)this.m_checkBox, "Before");
        this.add((Component)this.m_label, "Center");
        return this;
    }

    public void mouseClicked(MouseEvent me) {
        TreePath path = this.m_panel.getTree().getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        if (me.getX() > this.m_panel.getTree().getPathBounds((TreePath)path).x + this.checkBoxHotspot) {
            return;
        }
        EventLogBaseNode node = (EventLogBaseNode)path.getLastPathComponent();
        if (!node.isEnabled() || !this.m_tree.isEnabled()) {
            return;
        }
        node.setSelected(!node.isSelected());
        ((DefaultTreeModel)this.m_panel.getTree().getModel()).nodeChanged(node);
        this.m_panel.fireVWTaskPropertyChangedEvent(new VWTaskPropertyChangedEvent((Object)this.m_panel.getTree(), node.getName()));
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }
}

